using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;

using System.Windows.Forms;
using gov.va.med.vbecs.Common;


namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class DlgSelectRack
	/// </summary>
	public class DlgSelectRack : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.ToolTip toolTip1;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.TabControl tabRacks;
		private System.Windows.Forms.ColumnHeader colRack;
		private System.Windows.Forms.ColumnHeader colDate;
		private System.Windows.Forms.ColumnHeader colCheck;
		private System.Windows.Forms.ColumnHeader columnHeader1;
		private System.Windows.Forms.ColumnHeader columnHeader2;
		private System.Windows.Forms.ColumnHeader columnHeader3;
		private System.Windows.Forms.TabPage pageTest;
		private System.Windows.Forms.ListView lvTest;
		private System.Windows.Forms.TabPage pageRetest;
		private System.Windows.Forms.ListView lvRetest;
		private System.ComponentModel.IContainer components = null;
		private DataTable _dtRacks;
		private System.Windows.Forms.TabPage pagePartiallyTest;
		private System.Windows.Forms.ColumnHeader columnHeader4;
		private System.Windows.Forms.ColumnHeader columnHeader5;
		private System.Windows.Forms.ColumnHeader columnHeader6;
		private System.Windows.Forms.ColumnHeader columnHeader7;
		private System.Windows.Forms.ColumnHeader columnHeader8;
		private System.Windows.Forms.ColumnHeader columnHeader9;
		private System.Windows.Forms.ListView lvPartiallyTested;
		private System.Windows.Forms.ColumnHeader columnHeader10;
		private System.Windows.Forms.ColumnHeader columnHeader11;
		private System.Windows.Forms.ColumnHeader columnHeader12;
		private System.Windows.Forms.GroupBox grpRack;
		private System.Windows.Forms.GroupBox grpTestDateUser;
		private System.Windows.Forms.Label lblTestedBy;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbTestedBy;
		private System.Windows.Forms.DateTimePicker dtpDateTested;
		private System.Windows.Forms.Label lblDateTested;
		private int _nCheckedItems = 0;
		private DateTime _currentDate;

		/// <summary>
		/// Constructor
		/// </summary>
		public DlgSelectRack()
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();
			_currentDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();

			SetComponentProperties();
			LoadRackList();
			LoadUserList();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DlgSelectRack));
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.btnCancel = new System.Windows.Forms.Button();
			this.toolTip1 = new System.Windows.Forms.ToolTip(this.components);
			this.lvTest = new System.Windows.Forms.ListView();
			this.columnHeader1 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader2 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader3 = new System.Windows.Forms.ColumnHeader();
			this.lvRetest = new System.Windows.Forms.ListView();
			this.colCheck = new System.Windows.Forms.ColumnHeader();
			this.colRack = new System.Windows.Forms.ColumnHeader();
			this.colDate = new System.Windows.Forms.ColumnHeader();
			this.lvPartiallyTested = new System.Windows.Forms.ListView();
			this.columnHeader10 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader11 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader12 = new System.Windows.Forms.ColumnHeader();
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.tabRacks = new System.Windows.Forms.TabControl();
			this.pageTest = new System.Windows.Forms.TabPage();
			this.pagePartiallyTest = new System.Windows.Forms.TabPage();
			this.pageRetest = new System.Windows.Forms.TabPage();
			this.columnHeader4 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader5 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader6 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader7 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader8 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader9 = new System.Windows.Forms.ColumnHeader();
			this.grpRack = new System.Windows.Forms.GroupBox();
			this.grpTestDateUser = new System.Windows.Forms.GroupBox();
			this.lblTestedBy = new System.Windows.Forms.Label();
			this.cmbTestedBy = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.dtpDateTested = new System.Windows.Forms.DateTimePicker();
			this.lblDateTested = new System.Windows.Forms.Label();
			this.grpImage.SuspendLayout();
			this.tabRacks.SuspendLayout();
			this.pageTest.SuspendLayout();
			this.pagePartiallyTest.SuspendLayout();
			this.pageRetest.SuspendLayout();
			this.grpRack.SuspendLayout();
			this.grpTestDateUser.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(384, 30);
			this.vbecsLogo1.TabIndex = 4;
			this.vbecsLogo1.Title = "Daily QC - Select Racks";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 325);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 6;
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnOK.EnabledButton = false;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = null;
			this.btnOK.Location = new System.Drawing.Point(224, 305);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 2;
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(304, 305);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 3;
			this.btnCancel.Text = "&Cancel";
			this.toolTip1.SetToolTip(this.btnCancel, "Click to disregard changes and return");
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// lvTest
			// 
			this.lvTest.AccessibleDescription = "Test Racks";
			this.lvTest.AccessibleName = "Test Racks";
			this.lvTest.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvTest.CheckBoxes = true;
			this.lvTest.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																					 this.columnHeader1,
																					 this.columnHeader2,
																					 this.columnHeader3});
			this.lvTest.FullRowSelect = true;
			this.lvTest.Location = new System.Drawing.Point(4, 4);
			this.lvTest.MultiSelect = false;
			this.lvTest.Name = "lvTest";
			this.lvTest.Size = new System.Drawing.Size(288, 124);
			this.lvTest.TabIndex = 0;
			this.toolTip1.SetToolTip(this.lvTest, "Check boxes to select one or more racks for testing.");
			this.lvTest.View = System.Windows.Forms.View.Details;
			this.lvTest.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.lvTest_ColumnClick);
			this.lvTest.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.lvTest_ItemCheck);
			// 
			// columnHeader1
			// 
			this.columnHeader1.Text = "";
			this.columnHeader1.Width = 25;
			// 
			// columnHeader2
			// 
			this.columnHeader2.Text = "Rack";
			// 
			// columnHeader3
			// 
			this.columnHeader3.Text = "Tested";
			this.columnHeader3.Width = 130;
			// 
			// lvRetest
			// 
			this.lvRetest.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvRetest.CheckBoxes = true;
			this.lvRetest.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																					   this.colCheck,
																					   this.colRack,
																					   this.colDate});
			this.lvRetest.FullRowSelect = true;
			this.lvRetest.Location = new System.Drawing.Point(4, 4);
			this.lvRetest.MultiSelect = false;
			this.lvRetest.Name = "lvRetest";
			this.lvRetest.Size = new System.Drawing.Size(288, 124);
			this.lvRetest.TabIndex = 0;
			this.lvRetest.View = System.Windows.Forms.View.Details;
			this.lvRetest.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.lvRetest_ColumnClick);
			this.lvRetest.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.lvRetest_ItemCheck);
			// 
			// colCheck
			// 
			this.colCheck.Text = "";
			this.colCheck.Width = 25;
			// 
			// colRack
			// 
			this.colRack.Text = "Rack";
			// 
			// colDate
			// 
			this.colDate.Text = "Tested";
			this.colDate.Width = 130;
			// 
			// lvPartiallyTested
			// 
			this.lvPartiallyTested.AccessibleDescription = "Partially Tested Racks";
			this.lvPartiallyTested.AccessibleName = "Partially Tested Racks";
			this.lvPartiallyTested.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvPartiallyTested.CheckBoxes = true;
			this.lvPartiallyTested.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																								this.columnHeader10,
																								this.columnHeader11,
																								this.columnHeader12});
			this.lvPartiallyTested.FullRowSelect = true;
			this.lvPartiallyTested.Location = new System.Drawing.Point(4, 4);
			this.lvPartiallyTested.MultiSelect = false;
			this.lvPartiallyTested.Name = "lvPartiallyTested";
			this.lvPartiallyTested.Size = new System.Drawing.Size(288, 124);
			this.lvPartiallyTested.TabIndex = 1;
			this.lvPartiallyTested.View = System.Windows.Forms.View.Details;
			this.lvPartiallyTested.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.lvPartiallyTested_ColumnClick);
			this.lvPartiallyTested.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.lvPartiallyTested_ItemCheck);
			// 
			// columnHeader10
			// 
			this.columnHeader10.Text = "";
			this.columnHeader10.Width = 25;
			// 
			// columnHeader11
			// 
			this.columnHeader11.Text = "Rack";
			// 
			// columnHeader12
			// 
			this.columnHeader12.Text = "Tested";
			this.columnHeader12.Width = 130;
			// 
			// grpImage
			// 
			this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage.Controls.Add(this.pictureBox1);
			this.grpImage.Location = new System.Drawing.Point(4, 32);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(52, 257);
			this.grpImage.TabIndex = 5;
			this.grpImage.TabStop = false;
			// 
			// pictureBox1
			// 
			this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
			this.pictureBox1.Location = new System.Drawing.Point(4, 12);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new System.Drawing.Size(45, 44);
			this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox1.TabIndex = 0;
			this.pictureBox1.TabStop = false;
			// 
			// tabRacks
			// 
			this.tabRacks.AccessibleDescription = "Retest Racks";
			this.tabRacks.AccessibleName = "Retest Racks";
			this.tabRacks.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.tabRacks.Controls.Add(this.pageTest);
			this.tabRacks.Controls.Add(this.pagePartiallyTest);
			this.tabRacks.Controls.Add(this.pageRetest);
			this.tabRacks.Location = new System.Drawing.Point(8, 16);
			this.tabRacks.Name = "tabRacks";
			this.tabRacks.SelectedIndex = 0;
			this.tabRacks.Size = new System.Drawing.Size(304, 160);
			this.tabRacks.TabIndex = 0;
			// 
			// pageTest
			// 
			this.pageTest.Controls.Add(this.lvTest);
			this.pageTest.Location = new System.Drawing.Point(4, 23);
			this.pageTest.Name = "pageTest";
			this.pageTest.Size = new System.Drawing.Size(296, 133);
			this.pageTest.TabIndex = 0;
			this.pageTest.Text = "Test Rack(s)";
			// 
			// pagePartiallyTest
			// 
			this.pagePartiallyTest.Controls.Add(this.lvPartiallyTested);
			this.pagePartiallyTest.Location = new System.Drawing.Point(4, 23);
			this.pagePartiallyTest.Name = "pagePartiallyTest";
			this.pagePartiallyTest.Size = new System.Drawing.Size(296, 133);
			this.pagePartiallyTest.TabIndex = 2;
			this.pagePartiallyTest.Text = "Partially Tested Rack(s)";
			// 
			// pageRetest
			// 
			this.pageRetest.Controls.Add(this.lvRetest);
			this.pageRetest.Location = new System.Drawing.Point(4, 23);
			this.pageRetest.Name = "pageRetest";
			this.pageRetest.Size = new System.Drawing.Size(296, 133);
			this.pageRetest.TabIndex = 1;
			this.pageRetest.Text = "Retest Rack(s)";
			// 
			// columnHeader4
			// 
			this.columnHeader4.Text = "";
			this.columnHeader4.Width = 25;
			// 
			// columnHeader5
			// 
			this.columnHeader5.Text = "Rack";
			// 
			// columnHeader6
			// 
			this.columnHeader6.Text = "Tested";
			this.columnHeader6.Width = 130;
			// 
			// columnHeader7
			// 
			this.columnHeader7.Text = "";
			this.columnHeader7.Width = 25;
			// 
			// columnHeader8
			// 
			this.columnHeader8.Text = "Rack";
			// 
			// columnHeader9
			// 
			this.columnHeader9.Text = "Tested";
			this.columnHeader9.Width = 130;
			// 
			// grpRack
			// 
			this.grpRack.AccessibleDescription = "Select Racks";
			this.grpRack.AccessibleName = "Select Racks";
			this.grpRack.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpRack.Controls.Add(this.tabRacks);
			this.grpRack.Location = new System.Drawing.Point(60, 104);
			this.grpRack.Name = "grpRack";
			this.grpRack.Size = new System.Drawing.Size(320, 184);
			this.grpRack.TabIndex = 1;
			this.grpRack.TabStop = false;
			this.grpRack.Text = "Select Rack(s)*";
			// 
			// grpTestDateUser
			// 
			this.grpTestDateUser.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpTestDateUser.Controls.Add(this.lblTestedBy);
			this.grpTestDateUser.Controls.Add(this.cmbTestedBy);
			this.grpTestDateUser.Controls.Add(this.dtpDateTested);
			this.grpTestDateUser.Controls.Add(this.lblDateTested);
			this.grpTestDateUser.Location = new System.Drawing.Point(60, 32);
			this.grpTestDateUser.Name = "grpTestDateUser";
			this.grpTestDateUser.Size = new System.Drawing.Size(320, 68);
			this.grpTestDateUser.TabIndex = 0;
			this.grpTestDateUser.TabStop = false;
			// 
			// lblTestedBy
			// 
			this.lblTestedBy.Location = new System.Drawing.Point(8, 40);
			this.lblTestedBy.Name = "lblTestedBy";
			this.lblTestedBy.Size = new System.Drawing.Size(72, 20);
			this.lblTestedBy.TabIndex = 2;
			this.lblTestedBy.Text = "Tested By*";
			this.lblTestedBy.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// cmbTestedBy
			// 
			this.cmbTestedBy.AccessibleDescription = "Tested By";
			this.cmbTestedBy.AccessibleName = "Tested By";
			this.cmbTestedBy.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbTestedBy.Interval = 100;
			this.cmbTestedBy.Location = new System.Drawing.Point(80, 40);
			this.cmbTestedBy.Name = "cmbTestedBy";
			this.cmbTestedBy.Size = new System.Drawing.Size(232, 22);
			this.cmbTestedBy.TabIndex = 3;
			// 
			// dtpDateTested
			// 
			this.dtpDateTested.AccessibleDescription = "Date Tested";
			this.dtpDateTested.AccessibleName = "Date Tested";
			this.dtpDateTested.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.dtpDateTested.CustomFormat = "MM/dd/yyyy HH:mm";
			this.dtpDateTested.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpDateTested.Location = new System.Drawing.Point(80, 12);
			this.dtpDateTested.Name = "dtpDateTested";
			this.dtpDateTested.Size = new System.Drawing.Size(232, 20);
			this.dtpDateTested.TabIndex = 1;
			this.dtpDateTested.ValueChanged += new System.EventHandler(this.dtpDateTested_ValueChanged);
			// 
			// lblDateTested
			// 
			this.lblDateTested.Location = new System.Drawing.Point(8, 12);
			this.lblDateTested.Name = "lblDateTested";
			this.lblDateTested.Size = new System.Drawing.Size(72, 20);
			this.lblDateTested.TabIndex = 0;
			this.lblDateTested.Text = "Date Tested*";
			this.lblDateTested.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// DlgSelectRack
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(384, 341);
			this.Controls.Add(this.grpTestDateUser);
			this.Controls.Add(this.grpImage);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.grpRack);
			this.hlphelpChm.SetHelpKeyword(this, "Enter_Daily_QC_Results.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MinimumSize = new System.Drawing.Size(392, 368);
			this.Name = "DlgSelectRack";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Enter Daily QC Results";
			this.Controls.SetChildIndex(this.grpRack, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.grpImage, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.Controls.SetChildIndex(this.grpTestDateUser, 0);
			this.grpImage.ResumeLayout(false);
			this.tabRacks.ResumeLayout(false);
			this.pageTest.ResumeLayout(false);
			this.pagePartiallyTest.ResumeLayout(false);
			this.pageRetest.ResumeLayout(false);
			this.grpRack.ResumeLayout(false);
			this.grpTestDateUser.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		private void SetComponentProperties()
		{
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			this.vbecsLogo1.Title = "Enter Daily QC Results";
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC028.DlgSelectRack());
			//
			this.btnOK.Text = "&OK";
			this.btnOK.EnabledButton = false;
			this.dtpDateTested.Value = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
		}

		private void LoadRackList()
		{
			this.lvTest.Items.Clear();
			this.lvPartiallyTested.Items.Clear();
			this.lvRetest.Items.Clear();

			try
			{
				_dtRacks = BOL.Rack.GetDailyQCRacks(this.dtpDateTested.Value);
			}
			catch (Exception err)
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.Dynamic(err.Message));
			}


			if (_dtRacks.Rows.Count > 0)
			{

				foreach(DataRow drRack in _dtRacks.Rows)
				{
					if (drRack.IsNull(Common.VbecsTables.DailyQcWorklist.DailyQcExpirationDate))
					{
						ListViewItem lvItem = new ListViewItem();
						lvItem.SubItems.Add(drRack[Common.VbecsTables.Rack.RackName].ToString());
						lvItem.SubItems.Add(string.Empty);
						lvItem.Tag = drRack;
						this.lvTest.Items.Add(lvItem);
					}
					else if ((bool)drRack[Common.VbecsTables.DailyQcWorklist.DailyUseIndicator] == false)
					{
						ListViewItem lvItem = new ListViewItem();
						lvItem.SubItems.Add(drRack[Common.VbecsTables.Rack.RackName].ToString());
						lvItem.SubItems.Add(string.Empty);
						lvItem.Tag = drRack;
						this.lvTest.Items.Add(lvItem);
					}
					else if ((bool)drRack[Common.VbecsTables.DailyQcWorklist.PartiallyTestedIndicator] == true)
					{
						ListViewItem lvItem = new ListViewItem();
						lvItem.SubItems.Add(drRack[Common.VbecsTables.Rack.RackName].ToString());
						DateTime rackTestDate = BOL.Rack.GetRackTestDate((Guid)drRack[Common.VbecsTables.DailyQcWorklist.DailyQcWorklistGuid]);
						if (rackTestDate != DateTime.MinValue)
							lvItem.SubItems.Add(Common.VBECSDateTime.FormatDateTimeString(rackTestDate));
						else
							lvItem.SubItems.Add(string.Empty);
						lvItem.Tag = drRack;
						this.lvPartiallyTested.Items.Add(lvItem);
					}
					else
					{
						ListViewItem lvItem = new ListViewItem();
						lvItem.SubItems.Add(drRack[Common.VbecsTables.Rack.RackName].ToString());
						DateTime rackTestDate = BOL.Rack.GetRackTestDate((Guid)drRack[Common.VbecsTables.DailyQcWorklist.DailyQcWorklistGuid]);
						if (rackTestDate != DateTime.MinValue)
							lvItem.SubItems.Add(Common.VBECSDateTime.FormatDateTimeString(rackTestDate));
						else
							lvItem.SubItems.Add(string.Empty);
						lvItem.Tag = drRack;
						this.lvRetest.Items.Add(lvItem);
					}
				}
				//
				controls.VbecsFunction.SetColumnWidths(this.lvTest);
				controls.VbecsFunction.SetColumnWidths(this.lvPartiallyTested);
				controls.VbecsFunction.SetColumnWidths(this.lvRetest);
			}
		}

		private void LoadUserList()
		{
			cmbTestedBy.SelectedIndex = -1;
			cmbTestedBy.Items.Clear();
			
			foreach( BOL.VbecsUser _user in BOL.VbecsUser.GetActiveDivisionUsers( LogonUser.LogonUserDivisionCode ) )
				this.cmbTestedBy.Items.Add( _user.UserName );

			this.cmbTestedBy.SelectedItem = ThisUser.UserName;
		}

		private void btnOK_Click(object sender, System.EventArgs e)
		{
			if (IsCurrentUserAuthorizedForFunction(Common.FunctionCode.StandardAccess))
			{
				DataTable dtSelectedRacks = _dtRacks.Clone();

				//getting not-tested racks
				foreach(ListViewItem lvItem in this.lvTest.Items)
				{
					if (lvItem.Checked == true)
					{
						dtSelectedRacks.Rows.Add(((DataRow)lvItem.Tag).ItemArray);
					}
				}

				//getting racks chosen for retest
				foreach(ListViewItem lvItem in this.lvRetest.Items)
				{
					if (lvItem.Checked == true)
					{
						dtSelectedRacks.Rows.Add(((DataRow)lvItem.Tag).ItemArray);
					}
				}

				//getting racks chosen for retest
				foreach(ListViewItem lvItem in this.lvPartiallyTested.Items)
				{
					if (lvItem.Checked == true)
					{
						dtSelectedRacks.Rows.Add(((DataRow)lvItem.Tag).ItemArray);
					}
				}

				string testingTechID = (string)this.cmbTestedBy.SelectedItem;
				DateTime testDateTime = this.dtpDateTested.Value;

                //CR 3298
				FrmRecordLotNumbers frmLot = new FrmRecordLotNumbers(dtSelectedRacks, testDateTime, testingTechID);
				if (frmLot.ProceedWithLoad == true)
				{
					FrmDailyReagentRackQC frmQC = new FrmDailyReagentRackQC(dtSelectedRacks, frmLot.DTLotNumbers, testingTechID, testDateTime);
					frmLot.MdiParent = this.MdiParent;
					frmQC.MdiParent = this.MdiParent;
					frmLot.Tag = frmQC;
					frmQC.Tag = frmLot;
					frmLot.Show();          //TODO: frmLot is the locking form, and no special ShowDialog?
				}
				this.Close();		//We're going to close the form regardless of the RC
			}
			else
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.InsufficientSecurityPrivileges("perform this function"));
			}
		}

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		private void lvTest_ItemCheck(object sender, System.Windows.Forms.ItemCheckEventArgs e)
		{
			if (e.NewValue == System.Windows.Forms.CheckState.Checked)
			{
				_nCheckedItems++;
			}
			else
			{
				_nCheckedItems--;
			}
			if (_nCheckedItems == 0)
			{
				this.btnOK.EnabledButton = false;
			}
			else
			{
				this.btnOK.EnabledButton = true;
			}
		}

		private void lvRetest_ItemCheck(object sender, System.Windows.Forms.ItemCheckEventArgs e)
		{
			if (e.NewValue == System.Windows.Forms.CheckState.Checked)
			{
				_nCheckedItems++;
			}
			else
			{
				_nCheckedItems--;
			}
			if (_nCheckedItems == 0)
			{
				this.btnOK.EnabledButton = false;
			}
			else
			{
				this.btnOK.EnabledButton = true;
			}
		}

		private void lvPartiallyTested_ItemCheck(object sender, System.Windows.Forms.ItemCheckEventArgs e)
		{
			if (e.NewValue == System.Windows.Forms.CheckState.Checked)
			{
				_nCheckedItems++;
			}
			else
			{
				_nCheckedItems--;
			}
			if (_nCheckedItems == 0)
			{
				this.btnOK.EnabledButton = false;
			}
			else
			{
				this.btnOK.EnabledButton = true;
			}
		}

		private void lvTest_ColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e)
		{
			if (e.Column == 2)
			{
				controls.ColumnClickSorter.ColumnClickHandler(sender, e, lvTest.CheckBoxes, controls.ColumnClickSorter.ColumnSortType.DateTime);
			}
			else 
			{
				controls.ColumnClickSorter.ColumnClickHandler(sender, e, lvTest.CheckBoxes, controls.ColumnClickSorter.ColumnSortType.String);
			}

		}

		private void lvPartiallyTested_ColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e)
		{
			if (e.Column == 2)
			{
				controls.ColumnClickSorter.ColumnClickHandler(sender, e, lvPartiallyTested.CheckBoxes, controls.ColumnClickSorter.ColumnSortType.DateTime);
			}
			else 
			{
				controls.ColumnClickSorter.ColumnClickHandler(sender, e, lvPartiallyTested.CheckBoxes, controls.ColumnClickSorter.ColumnSortType.String);
			}
		}

		private void lvRetest_ColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e)
		{
			if (e.Column == 2)
			{
				controls.ColumnClickSorter.ColumnClickHandler(sender, e, lvRetest.CheckBoxes, controls.ColumnClickSorter.ColumnSortType.DateTime);
			}
			else 
			{
				controls.ColumnClickSorter.ColumnClickHandler(sender, e, lvRetest.CheckBoxes, controls.ColumnClickSorter.ColumnSortType.String);
			}
		}

		private void dtpDateTested_ValueChanged(object sender, System.EventArgs e)
		{
			if (this.dtpDateTested.Value > _currentDate)
			{
				this.dtpDateTested.Value = _currentDate;
			}

			this.LoadRackList();
			this.btnOK.EnabledButton = false;
			this._nCheckedItems = 0;
		}
	}
}

